<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Dashboard extends CI_Controller
{

  function __construct()
  {
    parent::__construct();
    // $this->load->database();
    $this->load->helper('url');
    $this->load->library('session');
    $this->load->model('dashboard_model');
    $this->load->model('common');
    $this->load->model('geofence_model');
  }
   public function report()
  {
    $data["reports"] = $this->common->readdatafromcollectionbetween("Reports");
    foreach($data["reports"] as $key => $value){

      $data["reports"][$key]["reportedUser"] = $this->common->readdatadocument("Users", $value["reportedUserID"]);
      @$data["reports"][$key]["reportedUser"]['isDeleted'] = false;
      if(is_null($data["reports"][$key]["reportedUser"]) || empty($data["reports"][$key]["reportedUser"])) {
        $data["reports"][$key]["reportedUser"] = $this->common->readdatadocument("DeletedUser", $value['reportedUserID']);
        @$data["reports"][$key]["reportedUser"]['isDeleted'] = true;
      }
      $data["reports"][$key]["reportedFrom"] = $this->common->readdatadocument("Users", $value["userId"]);
      @$data["reports"][$key]["reportedFrom"]['isDeleted'] = false;
      if(is_null($data["reports"][$key]["reportedFrom"]) || empty($data["reports"][$key]["reportedFrom"])) {
        $data["reports"][$key]["reportedFrom"] = $this->common->readdatadocument("DeletedUser", $value['userId']);
        @$data["reports"][$key]["reportedFrom"]['isDeleted'] = false;
      }
    }
    $this->template->template_render('report', $data);
  }

  public function settings()
  {
    $data["settings"] = $this->common->readdatafromcollectionbetween("Settings");
    
    $this->template->template_render('settings', $data);
  }

  public function saveSettings()
  {
    $post = $this->input->post();
    $response = $this->common->updatedatamodel("Settings", $post['id'], $post);
    if($response) {
				$this->session->set_flashdata('successmessage', '2Fa Secret Key has been updated');
    }else{
			$this->session->set_flashdata('warningmessage', 'Error! Some issue with firebase.Please try again');
    }

    redirect(base_url('dashboard/settings'));
  }



  public function index()
  {
  
    $data["users"] = $this->common->readnumberofdocumentsincollectionbetween("Users", 'userRole', '=', 'user');
    //chart labels and data
  
    $data["artists"] = 0;
    $data["producers"] =0 ;
    $data["instrumentalists"] = 0;
    $data["songwriters"] = 0;
    $data["professionals"] =0;
    $data["podcasts"] = 0;

    $data['anaylatic'] =array();

    $data['pageanaylatic'] =[];
    // echo "<pre>";
    // print_r($data['pageanaylatic']);
    // echo "</pre>";
   
    $this->template->template_render('dashboard', $data);
  }



  public function iechart()
  {
    $data = $this->common->get_iechartdata();
    $res = "['" . implode("', '", array_keys($data)) . "']";
    $income = "['" . implode("', '", array_column($data, 'income')) . "']";
    $expense = "['" . implode("', '", array_column($data, 'expense')) . "']";
    echo json_encode(array('res' => $res, 'admin' => $income, 'driver' => $expense));
  }
  public function remindermark()
  {
    $data = array('r_isread' => 1);
    $this->db->where('r_id', $this->input->post('r_id'));
    echo $this->db->update('reminder', $data);
  }
}